
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SERV_OS_IMPOSTO_GLB_IMPOSTOS]') AND parent_object_id = OBJECT_ID(N'[dbo].[SERV_OS_IMPOSTO]'))
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [FK_SERV_OS_IMPOSTO_GLB_IMPOSTOS]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SERV_OS_IMPOSTO_SERV_OS_SERVICO]') AND parent_object_id = OBJECT_ID(N'[dbo].[SERV_OS_IMPOSTO]'))
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [FK_SERV_OS_IMPOSTO_SERV_OS_SERVICO]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_CD_EMP]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_EMP]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_CD_FILIAL]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_FILIAL]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_CD_SERV]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_SERV]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_CD_OS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_OS]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_CD_IMP]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_IMP]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_PERC_IMP]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_PERC_IMP]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_SERV_OS_IMPOSTO_ANO_OS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[SERV_OS_IMPOSTO] DROP CONSTRAINT [DF_SERV_OS_IMPOSTO_ANO_OS]
END

GO


/****** Object:  Table [dbo].[SERV_OS_IMPOSTO]    Script Date: 03/28/2014 08:19:45 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SERV_OS_IMPOSTO]') AND type in (N'U'))
DROP TABLE [dbo].[SERV_OS_IMPOSTO]
GO


/****** Object:  Table [dbo].[SERV_OS_IMPOSTO]    Script Date: 03/28/2014 08:19:45 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[SERV_OS_IMPOSTO](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_OS] [int] NOT NULL,
	[CD_IMP] [int] NOT NULL,
	[PERC_IMP] [money] NOT NULL,
	[ANO_OS] [int] NOT NULL,
 CONSTRAINT [PK_SERV_OS_IMPOSTO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_OS] ASC,
	[CD_IMP] ASC,
	[ANO_OS] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO]  WITH NOCHECK ADD  CONSTRAINT [FK_SERV_OS_IMPOSTO_GLB_IMPOSTOS] FOREIGN KEY([CD_IMP])
REFERENCES [dbo].[GLB_IMPOSTOS] ([CD_CTR])
ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] CHECK CONSTRAINT [FK_SERV_OS_IMPOSTO_GLB_IMPOSTOS]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO]  WITH NOCHECK ADD  CONSTRAINT [FK_SERV_OS_IMPOSTO_SERV_OS_SERVICO] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_OS], [ANO_OS])
REFERENCES [dbo].[SERV_OS] ([CD_EMP], [CD_FILIAL], [CD_OS], [ANO_OS])
ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] CHECK CONSTRAINT [FK_SERV_OS_IMPOSTO_SERV_OS_SERVICO]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] ADD  CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] ADD  CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] ADD  CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_OS]  DEFAULT ((0)) FOR [CD_OS]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] ADD  CONSTRAINT [DF_SERV_OS_IMPOSTO_CD_IMP]  DEFAULT ((0)) FOR [CD_IMP]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] ADD  CONSTRAINT [DF_SERV_OS_IMPOSTO_PERC_IMP]  DEFAULT ((0)) FOR [PERC_IMP]
GO

ALTER TABLE [dbo].[SERV_OS_IMPOSTO] ADD  CONSTRAINT [DF_SERV_OS_IMPOSTO_ANO_OS]  DEFAULT ((0)) FOR [ANO_OS]
GO


